$(document).ready(function() {
  // Show modal when clicking support link
  $('.support-link').on('click', function(e) {
    e.preventDefault();
    $('#supportModal').show();
  });

  // Close modal
  $('.close').on('click', function() {
    const modalId = $(this).data('modal');
    $('#' + modalId).hide();
  });

  // Close modal when clicking outside
  $('.modal').on('click', function(e) {
    if (e.target === this) {
      $(this).hide();
    }
  });

  // Handle form submission
  $('#supportForm').submit(function(e) {
    e.preventDefault();
    let isValid = true;

    const subject = $('#supportSubject').val().trim();
    const message = $('#supportMessage').val().trim();

    $('#supportSubject_error').text('');
    $('#supportMessage_error').text('');
    $('#supportForm_message').text('');

    if (!subject) {
      $('#supportSubject_error').text('Subject is required');
      isValid = false;
    }
    if (!message) {
      $('#supportMessage_error').text('Message is required');
      isValid = false;
    }

    if (!isValid) return;

    $.ajax({
      url: '/api/support',
      method: 'POST',
      contentType: 'application/json',
      data: JSON.stringify({ subject, message }),
      success: function(response) {
        $('#supportForm_message').removeClass('error-message').addClass('success-message').text('Message sent successfully');
        $('#supportForm').trigger('reset');
        setTimeout(() => $('#supportModal').hide(), 2000);
      },
      error: function(err) {
        $('#supportForm_message').removeClass('success-message').addClass('error-message').text('Error sending message');
      }
    });
  });

  // Make modal draggable (adapted from networkingjs.js)
  function makeDraggable(modal) {
    const content = modal.querySelector('.help-content');
    let pos1 = 0, pos2 = 0, pos3 = 0, pos4 = 0;
    let isDragging = false;

    const dragMouseDown = (e) => {
      if (e.target.tagName === 'H3' || e.target === content) {
        e.preventDefault();
        isDragging = true;
        pos3 = e.clientX;
        pos4 = e.clientY;
        document.addEventListener('mousemove', elementDrag);
        document.addEventListener('mouseup', closeDragElement);
      }
    };

    const elementDrag = (e) => {
      if (!isDragging) return;
      e.preventDefault();
      pos1 = pos3 - e.clientX;
      pos2 = pos4 - e.clientY;
      pos3 = e.clientX;
      pos4 = e.clientY;
      const newTop = content.offsetTop - pos2;
      const newLeft = content.offsetLeft - pos1;
      const maxTop = window.innerHeight - content.offsetHeight;
      const maxLeft = window.innerWidth - content.offsetWidth;
      content.style.top = `${Math.max(0, Math.min(newTop, maxTop))}px`;
      content.style.left = `${Math.max(0, Math.min(newLeft, maxLeft))}px`;
    };

    const closeDragElement = () => {
      isDragging = false;
      document.removeEventListener('mousemove', elementDrag);
      document.removeEventListener('mouseup', closeDragElement);
    };

    content.style.position = 'absolute';
    content.style.top = '50%';
    content.style.left = '50%';
    content.style.transform = 'translate(-50%, -50%)';
    content.addEventListener('mousedown', dragMouseDown);
  }

  makeDraggable(document.getElementById('supportModal'));
});