document.getElementById('loginForm').addEventListener('submit', async (e) => {
    e.preventDefault();
    
    try {
      const response = await fetch('/login', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify({
          username: document.getElementById('username').value,
          password: document.getElementById('password').value,
          companyName: document.getElementById('companyName').value
        })
      });
  
      const data = await response.json();
      
      if (data.success) {
        localStorage.setItem('authToken', data.token);
        this.showSuccess('Login successful! Redirecting...');
        setTimeout(() => {
          window.location.href = data.redirect || '/entrance';
        }, 1000);
      } else {
        showError(data.error || 'Login failed');
      }
    } catch (error) {
      showError('Network error - please try again');
      console.error('Login error:', error);
    }
});
  // Add this to your WebinarManager class or as a global utility function
  function showError(message, duration = 3000) {
      // Remove any existing error messages
      const existingError = document.querySelector('.error-message');
      if (existingError) existingError.remove();
    
      // Create error element
      const errorElement = document.createElement('div');
      errorElement.className = 'error-message';
      errorElement.textContent = message;
    
      // Add to DOM
      document.body.appendChild(errorElement);
    
      // Auto-remove after duration
      setTimeout(() => {
        errorElement.remove();
      }, duration);
  }
  
  // Also add a showSuccess function for consistency
  function showSuccess(message, duration = 3000) {
    const successElement = document.createElement('div');
    successElement.className = 'error-message'; // Reuse same styling
    successElement.style.backgroundColor = '#4CAF50'; // Green for success
    successElement.textContent = message;
    document.body.appendChild(successElement);
    setTimeout(() => successElement.remove(), duration);
  }
  // Add to login.js, inside DOMContentLoaded
document.addEventListener('DOMContentLoaded', () => {
  const urlParams = new URLSearchParams(window.location.search);
  if (urlParams.get('message') === 'exhibition_ended') {
    showNotification('The exhibition has ended. Please contact support for details.', 'info');
  }

  
});

// Reuse showNotification from networkingjs.js or webinar.js
function showNotification(message, type = 'info') {
  const notification = document.createElement('div');
  notification.className = `notification ${type}`;
  notification.textContent = message;
  document.body.appendChild(notification);
  setTimeout(() => notification.remove(), 5000);
}