// jquery.hotspot.js

(function($) {
    'use strict';
  
    function _positionHotspots(options) {
      var imageWidth = $(options.mainselector + ' ' + options.imageselector).prop('naturalWidth');
      var imageHeight = $(options.mainselector + ' ' + options.imageselector).prop('naturalHeight');
  
      var bannerWidth = $(options.mainselector).width();
      var bannerHeight = $(options.mainselector).height();
  
      $(options.selector).each(function() {
        var xPos = $(this).attr('x');
        var yPos = $(this).attr('y');
        xPos = (xPos / imageWidth) * bannerWidth;
        yPos = (yPos / imageHeight) * bannerHeight;
  
        $(this).css({
          top: yPos,
          left: xPos,
          display: 'block',
        });
  
        $(this).children(options.tooltipselector).css({
          'margin-left': -$(this).children(options.tooltipselector).width() / 2,
        });
      });
    }
  
    function _bindHotspots(e, options) {
      if (options.bindselector === 'click' || options.bindselector === 'both') {
          $(e).on('click', function() {
              var companyId = $(e).data('company-id'); // Assuming company ID is stored in a data attribute
              var contentType = $(e).data('content-type'); // Assuming content type is stored in a data attribute
              if (contentType === 'image') {
                  handleImageHotspotClick(companyId);
              } else if (contentType === 'video') {
                  handleVideoHotspotClick(companyId);
              }else if (contentType === 'document') {
                handleDocumentHotspotClick(companyId);
            }
          });
      }
  }
  
  
    function getImagesForCarousel(folderPath) {
      var images = [];
  
      // Assuming you have the images in the specified folder
      // Fetch the image files dynamically
      $.ajax({
        url: folderPath,
        success: function (data) {
          $(data).find("a[href]:contains('.jpg'),a[href]:contains('.jpeg'),a[href]:contains('.png')")
            .each(function () {
              images.push(folderPath + '/' + $(this).attr("href"));
            });
        }
      });
  
      return images;
    }
  
    $.fn.hotSpot = function(options) {
      var _options = $.extend({}, $.fn.hotSpot.defaults, options);
  
      this.each(function() {
        _positionHotspots.call($(this), _options);
      });
  
      $(window).resize(function() {
        this.each(function() {
          _positionHotspots.call($(this), _options);
        });
      }.bind(this));
  
      switch (_options.bindselector) {
        case 'click':
          $(this).find(_options.selector).on('click', function (e) {
            _bindHotspots(e.currentTarget, _options);
          });
          break;
        case 'hover':
          $(this).find(_options.selector).hover(
            function (e) {
              _bindHotspots(e.currentTarget, _options);
            },
            function (e) {
              $(e.currentTarget).children(_options.tooltipselector).css('display', 'none');
            }
          );
          break;
        case 'both':
          $(this).find(_options.selector).on({
            mouseenter: function (e) {
              _bindHotspots(e.currentTarget, _options);
            },
            mouseleave: function (e) {
              $(e.currentTarget).children(_options.tooltipselector).css('display', 'none');
            },
            click: function (e) {
              _bindHotspots(e.currentTarget, _options);
            },
          });
          break;
        default:
          break;
      }
  
      return this;
    };
  
    $.fn.hotSpot.defaults = {
      mainselector: '#hotspotImg',
      selector: '.hot-spot',
      imageselector: '.img-responsive',
      tooltipselector: '.tooltip',
      bindselector: 'both',
    };
  
  })(jQuery);
  